	function alfa = CASCADE_PARALLEL_SECTIONS(P)
	
	% 	Computes the adaptor coefficients in a lattice wave 
	%	digital filter with lattice branches consisting of 
	%	first- and second-order parallel resonance circuits.
	%	The coefficient are for symmetric adaptors.
	%	The first-order section is a parallel capacitor 	
	
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2009-11-15
	% Modified by: 	 	 
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	
	P = flipud(cplxpair(P));
	alfa(1) = P(1)+1;
	for k = 2:2:length(P)-1
		alfa(k) = 1 -abs(P(k))^2;
		alfa(k+1) = (real(2*P(k))+1+abs(P(k))^2)/2;
	end
